package com.sap.idm.vds.connector.samplefile.impl;

import java.io.RandomAccessFile;
import java.io.IOException;

/**
 * This class is dedicated to do the most basic file operations for file management
 * @author I054742
 *
 */
public class FileBasicOperations {
	
	
	/* String to be added in the file */
	private String str = null;
	/* File to be managed */
	private RandomAccessFile file = null;
	
	
	/**
	 * Constructor
	 * @param file -> File to be managed
	 */
	public FileBasicOperations (RandomAccessFile file) {
		this.file = file;
	}
	
	
	/**
	 * Constructor
	 * @param file -> File to be managed
	 * @param newStr -> String to be added in the file
	 */
	public FileBasicOperations (RandomAccessFile file, String newStr) {
		this.file = file;
		this.str = newStr;
	}
	
	
	/**
	 * Sets the file to 'newFile'
	 * @param newFile -> New file
	 */
	void setFile (RandomAccessFile newFile) {
		this.file = newFile;
	}
	
	
	/**
	 * Sets the string to 'newStr'
	 * @param newStr -> New string
	 */
	void setStr (String newStr) {
		this.str = newStr;
	}
	
	
	/**
	 * Adds the string at the end of the file
	 * @return -> The result of the operation:
	 * 				- SUCCESS -> The operation was realized successfully
	 * 				- An error code corresponding with the error occurred
	 * @throws IOException
	 */
	int addAtEnd () throws IOException {
		return this.addAtPosition((int)this.file.length(), this.str);
	}
	
	
	/**
	 * Adds the string at the beginning of the file
	 * @return -> The result of the operation:
	 * 				- SUCCESS -> The operation was realized successfully
	 * 				- An error code corresponding with the error occurred
	 * @throws IOException
	 */
	int addAtBeginning () throws IOException {
		return this.addAtPosition(0, this.str);
	}
	
	
	/**
	 * Adds the string at the position 'pos'
	 * @return -> The result of the operation:
	 * 				- SUCCESS -> The operation was realized successfully
	 * 				- An error code corresponding with the error occurred
	 * @throws IOException
	 */
	int addAtPosition (int pos) throws IOException {
		return this.addAtPosition(pos, this.str);
	}
	
	
	/**
	 * Adds the string 'newStr' at the end of the file
	 * @return -> The result of the operation:
	 * 				- SUCCESS -> The operation was realized successfully
	 * 				- An error code corresponding with the error occurred
	 * @throws IOException
	 */
	int addAtEnd (String newStr) throws IOException {
		return this.addAtPosition((int)this.file.length(), newStr);
	}
	
	
	/**
	 * Adds the string 'newStr' at the beginning of the file
	 * @return -> The result of the operation:
	 * 				- SUCCESS -> The operation was realized successfully
	 * 				- An error code corresponding with the error occurred
	 * @throws IOException
	 */
	int addAtBeginning (String newStr) throws IOException {
		return this.addAtPosition(0, newStr);
	}
	
	
	/**
	 * Adds the string 'newStr' at the position 'pos'
	 * @return -> The result of the operation:
	 * 				- SUCCESS -> The operation was realized successfully
	 * 				- An error code corresponding with the error occurred
	 * @throws IOException
	 */
	int addAtPosition (int pos, String newStr) throws IOException {
		
		/* If the string to be added is a null object then this is indicated */
		if (newStr==null) {
			return FileConstants.NULL_STRING;
		}
		
		this.str = newStr;
		
		/* If the position where must be added the new string is before the end of file ... */
		if (pos<file.length()) {
			/* Copies the part of the file from 'pos' on */
			//byte [] b = new byte[(int)this.file.length()-pos];
			
			this.file.seek(pos);
			//this.file.read(b);
			String x = this.readChars();
			/* Writes the string to be written at the required position */
			this.file.seek(pos);
			this.file.writeChars(this.str);
			/* Writes the copied part at the end of file */
			this.file.seek(pos+this.str.length()*2);
			this.file.writeChars(x);
		}
		/* otherwise the position is at the end of file */
		else {
			if (pos>this.file.length()) pos = (int)this.file.length();
			/* Writes the string to be written at the end of file */
			this.file.seek(pos);
			this.file.writeChars(this.str);
		}
		return FileConstants.SUCCESS;
	}
	
	
	
	public String readChars () {
		
		String res = new String();
		while (true) {
			try {
				res+=this.file.readChar();
			}
			catch (Exception e) {
				break;
			}
		}
		return res;
	}
	
	
	
	/**
	 * Gets the first 'nBytes' of a file
	 * @param nBytes -> Number of bytes
	 * @return -> A String with the first 'nBytes' of the content of the file
	 * @throws IOException
	 */
	String getContent (int nBytes) throws IOException {
		
		/* Creates a byte array */
		//byte [] b = new byte[Math.min((int)this.file.length(),nBytes)];
		
		/* Reads the bytes */
		this.file.seek(0);
		//this.file.read(b);
		
		String res = this.readChars();	
		return res.substring(0,Math.min(nBytes,res.length()));
		
		/* Returns the String with the read bytes */
		//return new String(b);
	}
	
	
	/**
	 * Cleans the whole content of a file
	 */
	void clean () {
		try {
			this.file.setLength(0);
		}
		catch (IOException ioe) {}
	}
}
